package co.carmentang.bonvoyage;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ImageView;
import android.graphics.BitmapFactory;

public class DisplayImageActivity extends Activity {
	Button btnDelete;
	ImageView imageDetail;
	int imageId;
	Bitmap theImage;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.display);
		btnDelete = (Button) findViewById(R.id.btnDelete);
		imageDetail = (ImageView) findViewById(R.id.imageView1);
		/**
         *
		 * getting intent data from search and previous screen
		 */
		Intent intnt = getIntent();
		theImage = (Bitmap) intnt.getParcelableExtra("imagename");
        Log.d("Image WIDTH:****", String.valueOf(theImage.getWidth()));

        imageId = intnt.getIntExtra("imageid", 20);
		Log.d("Image ID:****", String.valueOf(imageId));
        int width = theImage.getWidth() * 4;
        int height= theImage.getHeight() * 4;
        Bitmap resizedbitmap=Bitmap.createScaledBitmap(theImage, width, height, true);
        /*
         ImageView img=(ImageView)findViewById(R.id.ImageView01);
    Bitmap bmp=BitmapFactory.decodeResource(getResources(), R.drawable.sc01);
    int width=200;
    int height=200;
    Bitmap resizedbitmap=Bitmap.createScaledBitmap(bmp, width, height, true);
    img.setImageBitmap(resizedbitmap);
         */



		imageDetail.setImageBitmap(resizedbitmap);
		btnDelete.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				/**
				 * create DatabaseHandler object
				 */
				DataBaseHandler db = new DataBaseHandler(
						DisplayImageActivity.this);
				/**
				 * Deleting records from database
				 */
				Log.d("Delete Image: ", "Deleting.....");
				db.deleteContact(new Contact(imageId));
				// /after deleting data go to main page
				Intent i = new Intent(DisplayImageActivity.this,
						Gallery.class);
				startActivity(i);
				finish();
			}
		});

	}
}